<?php
require_once 'db_connect.php';
if(!isset($_SESSION["user_id"])){ header("location: login.php"); exit; }

$settings_res = $conn->query("SELECT * FROM settings");
$settings = []; while($row = $settings_res->fetch_assoc()){ $settings[$row['setting_name']] = $row['setting_value']; }

$stmt = $conn->prepare("SELECT u.full_name, u.mobile, u.balance, u.profile_image, r.level_name FROM users u JOIN reseller_levels r ON u.level_id = r.id WHERE u.id = ?");
$stmt->bind_param("i", $_SESSION['user_id']); $stmt->execute();
$user = $stmt->get_result()->fetch_assoc(); $stmt->close();
if (!$user) { header("location: logout.php"); exit; }

$avatar_path = 'assets/images/default_avatar.png';
if (!empty($user['profile_image']) && file_exists($user['profile_image'])) { $avatar_path = $user['profile_image']; }

$unread_count = 0;
$unread_count_res = $conn->prepare("SELECT COUNT(id) as unread_count FROM notifications WHERE user_id = ? AND is_read = 0");
if ($unread_count_res) {
    $unread_count_res->bind_param("i", $_SESSION['user_id']); $unread_count_res->execute();
    $unread_count = $unread_count_res->get_result()->fetch_assoc()['unread_count'];
    $unread_count_res->close();
}
?>
<!DOCTYPE html><html lang="bn"><head><meta charset="UTF-8"><meta name="viewport" content="width=device-width, initial-scale=1.0">
<title><?php echo $page_title ?? 'ড্যাশবোর্ড'; ?> - <?php echo htmlspecialchars($settings['site_name'] ?? 'Web Topup'); ?></title>
<link rel="icon" href="<?php echo htmlspecialchars($settings['site_favicon'] ?? 'assets/images/favicon.ico'); ?>"><link rel="stylesheet" href="assets/css/style.css"><link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet"><link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css"><link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css"/></head>
<body>
<div class="offcanvas offcanvas-start text-bg-dark" tabindex="-1" id="userSidebar" style="width: 300px;">
    <div class="offcanvas-header border-bottom border-secondary">
        <h5 class="offcanvas-title"><img src="<?php echo $avatar_path; ?>" alt="Avatar" class="rounded-circle" width="40" height="40" style="object-fit: cover;"><span class="ms-2"><?php echo htmlspecialchars($user['full_name']); ?></span></h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas"></button>
    </div>
    <div class="offcanvas-body"><ul class="list-group list-group-flush">
        <a href="index.php" class="list-group-item list-group-item-action bg-transparent text-white border-secondary"><i class="fas fa-home fa-fw me-2"></i> হোম</a>
        <a href="profile.php" class="list-group-item list-group-item-action bg-transparent text-white border-secondary"><i class="fas fa-user-circle fa-fw me-2"></i> আমার প্রোফাইল</a>
        <a href="statement.php" class="list-group-item list-group-item-action bg-transparent text-white border-secondary"><i class="fas fa-history fa-fw me-2"></i> লেনদেনের বিবরণী</a><hr class="bg-secondary">
        <a href="change_password.php" class="list-group-item list-group-item-action bg-transparent text-white border-secondary"><i class="fas fa-key fa-fw me-2"></i> পাসওয়ার্ড পরিবর্তন</a>
        <a href="change_pin.php" class="list-group-item list-group-item-action bg-transparent text-white border-secondary"><i class="fas fa-shield-alt fa-fw me-2"></i> পিন পরিবর্তন</a><hr class="bg-secondary">
        <a href="helpline.php" class="list-group-item list-group-item-action bg-transparent text-white border-secondary"><i class="fas fa-headset fa-fw me-2"></i> হেল্পলাইন</a>
        <a href="terms.php" class="list-group-item list-group-item-action bg-transparent text-white border-secondary"><i class="fas fa-file-contract fa-fw me-2"></i> শর্তাবলী</a>
        <a href="privacy.php" class="list-group-item list-group-item-action bg-transparent text-white border-secondary"><i class="fas fa-user-secret fa-fw me-2"></i> গোপনীয়তা নীতিমালা</a><hr class="bg-secondary">
        <a href="logout.php" class="list-group-item list-group-item-action bg-transparent text-danger border-secondary"><i class="fas fa-sign-out-alt fa-fw me-2"></i> লগআউট</a>
    </ul></div>
</div>
<div class="main-container">
    <header class="header">
        <div class="top-bar">
            <a href="#" data-bs-toggle="offcanvas" data-bs-target="#userSidebar" class="text-white"><i class="fas fa-bars"></i></a>
            <span><?php echo htmlspecialchars($settings['site_name'] ?? 'Web Topup'); ?></span>
            <a href="inbox.php" class="text-white position-relative"><i class="fas fa-bell"></i>
                <?php if (isset($unread_count) && $unread_count > 0): ?>
                    <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger" style="font-size: 0.6em; border: 1px solid white;"><?php echo $unread_count; ?></span>
                <?php endif; ?>
            </a>
        </div>
        <div class="user-profile">
            <img src="<?php echo $avatar_path; ?>" alt="User Avatar">
            <div class="user-info"><h4><?php echo htmlspecialchars($user['full_name']); ?></h4><p><?php echo htmlspecialchars($user['mobile']); ?></p><p><?php echo htmlspecialchars($user['level_name']); ?></p></div>
            <div id="balanceDisplay" class="balance-btn"><span>ব্যালেন্স দেখুন</span></div>
        </div>
    </header>