<?php 
$page_title = "ড্যাশবোর্ড";
require_once 'includes/user_header.php'; 

$sliders_result = $conn->query("SELECT * FROM sliders WHERE status = 'Active' ORDER BY sort_order ASC");
?>
    <div class="menu-grid">
        <a href="add_balance.php" class="menu-item"><img src="assets/images/add_balance.png" alt="Add Balance"><span>এড ব্যালেন্স</span></a>
        <a href="balance_transfer.php" class="menu-item"><img src="assets/images/transfer.png" alt="Transfer"><span>ব্যালেন্স ট্রান্সফার</span></a>
        <a href="statement.php" class="menu-item"><img src="assets/images/statement.png" alt="Statement"><span>স্টেটমেন্ট</span></a>
        <a href="recharge.php" class="menu-item"><img src="assets/images/recharge.png" alt="Recharge"><span>রিচার্জ</span></a>
        <a href="packages.php" class="menu-item"><img src="assets/images/package.png" alt="Package"><span>প্যাকেজ</span></a>
        <a href="pay_bill.php" class="menu-item"><img src="assets/images/pay_bill.png" alt="Pay Bill"><span>পে বিল</span></a>
        <a href="shopping.php" class="menu-item"><img src="assets/images/shopping.png" alt="Shopping"><span>শপিং</span></a>
        <a href="helpline.php" class="menu-item"><img src="assets/images/helpline.png" alt="Helpline"><span>হেল্পলাইন</span></a>
    </div>

    <div class="slider-container">
        <div class="swiper">
            <div class="swiper-wrapper">
                <?php if ($sliders_result && $sliders_result->num_rows > 0): while($slide = $sliders_result->fetch_assoc()): ?>
                <div class="swiper-slide">
                    <a href="<?php echo htmlspecialchars($slide['link_url'] ?? '#'); ?>" target="_blank"><img src="<?php echo htmlspecialchars($slide['image_url']); ?>" alt=""></a>
                </div>
                <?php endwhile; else: ?>
                <div class="swiper-slide"><img src="https://i.ibb.co/hR2sTfV/promo-banner.png" alt=""></div>
                <?php endif; ?>
            </div>
            <div class="swiper-pagination"></div>
        </div>
    </div>
    
    <div class="menu-grid" style="grid-template-columns: 1fr 1fr; padding-top: 0; padding-bottom: 0;">
        <a href="change_pin.php" class="menu-item"><img src="assets/images/change_pin.png" alt="Change PIN"><span>পিন পরিবর্তন</span></a>
        <a href="change_password.php" class="menu-item"><img src="assets/images/change_password.png" alt="Password"><span>পাসওয়ার্ড পরিবর্তন</span></a>
    </div>

<?php 
$conn->close();
include 'includes/user_footer.php'; 
?>