<?php
// Set the page title for the header
$page_title = "এডমিন অ্যাক্টিভিটি লগ";

// 1. Include the authentication check file. 
// This is the most important step for security. It ensures that only logged-in admins can access this page.
// It also provides the database connection ($conn) and the log_activity() function.
require_once 'includes/auth_check.php';

// 2. Include the header file.
// This will render the HTML head, body tag, and the admin sidebar navigation.
include 'includes/header.php';

// 3. Fetch activity logs from the database.
// We are joining the 'admin_activity_log' table with the 'users' table 
// to get the full name of the admin who performed the action, using their ID.
// We order the results by 'created_at' in descending order to show the most recent activities first.
// A LIMIT of 200 is used to prevent the page from slowing down if the log table becomes very large.
$logs_result = $conn->query(
    "SELECT l.id, l.action, l.details, l.ip_address, l.created_at, u.full_name 
     FROM admin_activity_log l 
     JOIN users u ON l.admin_id = u.id 
     ORDER BY l.created_at DESC 
     LIMIT 200"
);
?>

<div class="container-fluid">
    <h2 class="mb-4">এডমিন অ্যাক্টিভিটি লগ</h2>
    <p class="text-muted">এখানে এডমিন প্যানেলে করা সর্বশেষ ২০০টি কার্যক্রমের রেকর্ড দেখানো হলো।</p>

    <div class="card shadow-sm">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-striped table-hover">
                    <thead class="table-light">
                        <tr>
                            <th>ID</th>
                            <th>এডমিন</th>
                            <th>একশন</th>
                            <th>বিস্তারিত তথ্য</th>
                            <th>IP এড্রেস</th>
                            <th>সময়</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ($logs_result && $logs_result->num_rows > 0): ?>
                            <?php while($log = $logs_result->fetch_assoc()): ?>
                                <tr>
                                    <td><?php echo $log['id']; ?></td>
                                    <td><?php echo htmlspecialchars($log['full_name']); ?></td>
                                    <td><?php echo htmlspecialchars($log['action']); ?></td>
                                    <td><?php echo htmlspecialchars($log['details']); ?></td>
                                    <td><?php echo htmlspecialchars($log['ip_address']); ?></td>
                                    <td><?php echo date("d M, Y, h:i:s A", strtotime($log['created_at'])); ?></td>
                                </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="6" class="text-center">এখনো কোনো অ্যাক্টিভিটি লগ করা হয়নি।</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php
// 4. Include the footer file.
// This closes the main content div, body, and html tags and includes necessary JS scripts.
include 'includes/footer.php';

// 5. Close the database connection.
$conn->close();
?>